# 機能設計書 113-ルックアップ操作（Lookup Operations）

## 概要

本ドキュメントは、TensorFlowにおけるハッシュテーブル・語彙テーブルによるキー値検索機能の設計を記述する。

### 本機能の処理概要

ハッシュテーブルや語彙テーブルを用いたキー値検索操作を提供する。不変テーブル（HashTable）と可変テーブル（MutableHashTable、MutableDenseHashTable）の両方をサポートし、テキストファイルからの初期化やテンソルベースのルックアップを実現する。

**業務上の目的・背景**：自然言語処理における語彙IDへのマッピング、カテゴリカル特徴量のエンコーディング、埋め込みテーブルのルックアップなど、キー値ペアの高速検索はMLパイプラインの基本操作である。特に大規模語彙を扱うNLPタスクでは、文字列からIDへの変換を効率的に行う必要がある。

**機能の利用シーン**：テキスト前処理における単語からIDへの変換、Feature Column APIにおけるカテゴリカル特徴量の変換、推論時のラベルデコード、データパイプラインにおけるキー値マッピングなどで利用される。

**主要な処理内容**：
1. テーブルの生成（HashTable、MutableHashTable、MutableHashTableOfTensors、MutableDenseHashTable）
2. キー値検索（LookupTableFind/FindV2）
3. キー値挿入（LookupTableInsert/InsertV2）
4. キー値削除（LookupTableRemoveV2）
5. テーブルのエクスポート/インポート（LookupTableExport/Import）
6. テーブルサイズ取得（LookupTableSize）
7. テキストファイルからの初期化（InitializeTableFromTextFile）
8. 匿名テーブル（AnonymousHashTable、AnonymousMutableHashTable等）

**関連システム・外部連携**：TensorFlowのリソース管理システム、Feature Column API、tf.data パイプラインと連携する。

**権限による制御**：特になし。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | 該当なし | - | 本機能はバックエンドAPI機能であり、直接的な画面関連はない |

## 機能種別

データ検索 / CRUD操作

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| table_handle | resource / Ref(string) | Yes | テーブルハンドル | スカラー（V2）または2要素ベクトル（V1） |
| keys | Tensor（Tin型） | Yes（Find/Insert/Remove） | 検索キー | key_dtype属性と一致すること |
| default_value | Tensor（Tout型） | Yes（Find） | デフォルト値 | スカラーまたはベクトル |
| values | Tensor（Tout型） | Yes（Insert/Import） | 値テンソル | value_dtype属性と一致すること |
| key_dtype | type | Yes（テーブル生成時） | キーのデータ型 | - |
| value_dtype | type | Yes（テーブル生成時） | 値のデータ型 | - |
| empty_key | Tensor（key_dtype） | Yes（MutableDenseHashTable） | 空キー値 | - |
| deleted_key | Tensor（key_dtype） | Yes（MutableDenseHashTableV2） | 削除済みキー値 | - |
| filename | Tensor（string） | Yes（InitializeTableFromTextFile） | 語彙ファイルパス | スカラー |
| key_index | int | Yes（InitializeTableFromTextFile） | キーカラムインデックス | >= -2 |
| value_index | int | Yes（InitializeTableFromTextFile） | 値カラムインデックス | >= -2 |

### 入力データソース

Python API呼び出し、テキストファイル（語彙ファイル）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| values | Tensor（Tout型） | 検索結果の値テンソル |
| size | int64 | テーブルサイズ |
| keys | Tensor（Tkeys型） | エクスポートされたキー |
| exported_values | Tensor（Tvalues型） | エクスポートされた値 |
| table_handle | resource | 生成されたテーブルハンドル |

### 出力先

呼び出し元への戻り値として返却

## 処理フロー

### 処理シーケンス

```
1. テーブル生成
   └─ HashTableV2/MutableHashTableV2等でリソースハンドルを生成
   └─ InitializeTableV2またはInitializeTableFromTextFileV2で初期化

2. キー値検索（LookupTableFindV2）
   └─ テーブルハンドルの検証（rank 0）
   └─ ValidateTableResourceHandleで型チェック
   └─ キーに対応する値を返却（未登録キーはdefault_value）

3. キー値挿入（LookupTableInsertV2）
   └─ テーブルハンドルの検証
   └─ キー値ペアをテーブルに追加

4. テーブルエクスポート（LookupTableExportV2）
   └─ テーブル内の全キー値ペアを返却
```

### フローチャート

```mermaid
flowchart TD
    A[テーブル生成] --> B[テーブル初期化]
    B --> C{操作種別}
    C -->|Find| D[キー検索]
    C -->|Insert| E[キー値挿入]
    C -->|Remove| F[キー削除]
    C -->|Export| G[全データエクスポート]
    C -->|Import| H[バルクインポート]
    C -->|Size| I[サイズ取得]
    D --> J{キーが存在?}
    J -->|Yes| K[値を返却]
    J -->|No| L[default_valueを返却]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-113-01 | 型整合性検証 | テーブルのkey_dtype/value_dtypeと操作の型が一致すること | Find/Insert/Export操作時 |
| BR-113-02 | 不変テーブル | HashTableは初期化後の変更不可 | HashTable使用時 |
| BR-113-03 | MutableDenseHashTable設定 | 初期バケット数131072、最大負荷率0.8がデフォルト | MutableDenseHashTable生成時 |
| BR-113-04 | テキストファイル初期化 | デリミタのデフォルトはタブ文字 | InitializeTableFromTextFile使用時 |
| BR-113-05 | ステートフル操作 | テーブル操作はステートフルであり、Dataset関数内での使用にはALLOW_STATEFUL設定が必要 | Dataset関数内使用時 |

### 計算ロジック

ハッシュテーブルベースの定数時間O(1)ルックアップ。

## データベース操作仕様

該当なし（インメモリハッシュテーブル操作）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| InvalidArgument | 型不一致 | キー/値のdtypeがテーブル定義と異なる | 正しいdtypeを使用 |
| InvalidArgument | キーサフィックス不一致 | キーの形状がテーブルのキー形状のサフィックスと一致しない | キー形状を確認 |
| NotFound | テーブル未初期化 | 初期化前にFind操作を実行 | InitializeTableを先に実行 |

### リトライ仕様

該当なし

## トランザクション仕様

該当なし（個別操作はアトミック）

## パフォーマンス要件

ハッシュテーブルベースのため、検索・挿入は平均O(1)の計算量。MutableDenseHashTableは最大負荷率0.8でリハッシュが発生する。

## セキュリティ考慮事項

語彙ファイルの読み込み時にファイルパスの検証が必要。

## 備考

- V1系操作（LookupTableFind等）はRef(string)ハンドルを使用し、V2系操作（LookupTableFindV2等）はresourceハンドルを使用する。
- AnonymousHashTableは名前空間の衝突を避けるための匿名リソース。

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | lookup_ops.cc | `tensorflow/core/ops/lookup_ops.cc` | Op登録マクロ（REGISTER_OP）によるテーブル操作の入出力定義 |

**読解のコツ**: TensorFlowのOp登録ではREGISTER_OP マクロで入力（Input）、出力（Output）、属性（Attr）を定義し、SetShapeFnで形状推論ロジックを記述する。V1系（Ref(string)ハンドル）とV2系（resourceハンドル）の両方が登録されている。

#### Step 2: テーブルハンドル管理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | lookup_ops.cc | `tensorflow/core/ops/lookup_ops.cc` | MutableHashTableShape関数（320-338行目）でテーブルの形状情報管理 |

**主要処理フロー**:
1. **32-68行目**: ユーティリティ関数群 - 入力検証用のヘルパー関数
2. **71-89行目**: LookupTableFind - V1形式のキー検索Op
3. **91-160行目**: ValidateTableResourceHandle - テーブルリソースの型検証とキーサフィックス照合
4. **162-183行目**: LookupTableFindV2 - V2形式のキー検索Op（resourceハンドル使用）
5. **320-358行目**: MutableHashTableShape/MutableHashTableOfTensorsShapeFn - 可変テーブルの形状推論
6. **361-484行目**: 各種テーブル生成Op（HashTable, MutableHashTable, MutableDenseHashTable等）
7. **486-552行目**: テーブル初期化Op（InitializeTable, InitializeTableFromTextFile）

#### Step 3: テーブル操作を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | lookup_ops.cc | `tensorflow/core/ops/lookup_ops.cc` | Insert/Remove/Export/Import操作 |

**主要処理フロー**:
- **186-214行目**: LookupTableInsert/InsertV2 - キー値挿入
- **216-227行目**: LookupTableRemoveV2 - キー削除
- **229-283行目**: LookupTableSize/Export - テーブルサイズ取得とデータエクスポート
- **285-318行目**: LookupTableImport/ImportV2 - バルクデータインポート

### プログラム呼び出し階層図

```
Python API (tf.lookup.StaticHashTable等)
    │
    ├─ HashTableV2 / MutableHashTableV2 (テーブル生成)
    │       └─ SetShapeFn: ScalarOutput / MutableHashTableShapeFn
    │
    ├─ InitializeTableV2 / InitializeTableFromTextFileV2 (初期化)
    │
    ├─ LookupTableFindV2 (検索)
    │       └─ ValidateTableResourceHandle (型検証)
    │
    ├─ LookupTableInsertV2 (挿入)
    │
    ├─ LookupTableRemoveV2 (削除)
    │
    └─ LookupTableExportV2 / LookupTableImportV2 (エクスポート/インポート)
```

### データフロー図

```
[入力]                     [処理]                          [出力]

語彙ファイル ──────▶ InitializeTableFromTextFile ──▶ テーブル初期化
                                                        │
keys(Tensor) ─────▶ LookupTableFind ──────────────▶ values(Tensor)
default_value ────▶                                    (検索結果)
                                                        │
key-value pairs ──▶ LookupTableInsert ────────────▶ テーブル更新
                                                        │
table_handle ─────▶ LookupTableExport ────────────▶ keys + values
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| lookup_ops.cc | `tensorflow/core/ops/lookup_ops.cc` | ソース | C++ Op定義（全テーブル操作） |
| common_shape_fns.h | `tensorflow/core/framework/common_shape_fns.h` | ヘッダー | 共通形状推論関数 |
| dataset_stateful_op_allowlist.h | `tensorflow/core/framework/dataset_stateful_op_allowlist.h` | ヘッダー | Dataset内ステートフルOp許可リスト |
| op.h | `tensorflow/core/framework/op.h` | ヘッダー | REGISTER_OPマクロ定義 |
| shape_inference.h | `tensorflow/core/framework/shape_inference.h` | ヘッダー | 形状推論フレームワーク |
